<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "applications".
 *
 * @property int $id
 * @property string $surname
 * @property string $name
 * @property string|null $patronymic
 * @property int $category_id
 * @property int $game_id
 * @property int $user_id
 * @property string $date
 * @property string $time
 * @property string $adres
 * @property int $price
 * @property string $email
 * @property string $phone_number
 * @property string $status_player
 * @property int $payment_method
 * @property string $status
 *
 * @property Categories $category
 * @property Games $game
 * @property Users $user
 */
class Application extends \yii\db\ActiveRecord
{


    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'applications';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['patronymic'], 'default', 'value' => null],
            [['status'], 'default', 'value' => 'Новая'],
            [['surname', 'name', 'category_id', 'game_id', 'user_id', 'date', 'time', 'adres', 'price', 'email', 'phone_number', 'status_player', 'payment_method'], 'required'],
            [['category_id', 'game_id', 'user_id', 'price', 'payment_method'], 'integer'],
            [['date', 'time'], 'safe'],
            [['surname', 'name', 'patronymic', 'adres', 'email', 'status_player', 'status'], 'string', 'max' => 255],
            [['phone_number'], 'string', 'max' => 20],
            [['category_id'], 'exist', 'skipOnError' => true, 'targetClass' => Category::class, 'targetAttribute' => ['category_id' => 'id']],
            [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::class, 'targetAttribute' => ['user_id' => 'id']],
            [['game_id'], 'exist', 'skipOnError' => true, 'targetClass' => Game::class, 'targetAttribute' => ['game_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'surname' => 'Фамилия',
            'name' => 'Имя',
            'patronymic' => 'Отчество',
            'category_id' => 'Категория',
            'game_id' => 'Игра',
            'user_id' => 'Пользователь',
            'date' => 'Дата',
            'time' => 'Время',
            'adres' => 'Адрес',
            'price' => 'Цена билета',
            'email' => 'Email',
            'phone_number' => 'Номер телефона',
            'status_player' => 'Статус игрока',
            'payment_method' => 'Способ оплаты',
        ];
    }

    /**
     * Gets query for [[Category]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCategory()
    {
        return $this->hasOne(Category::class, ['id' => 'category_id']);
    }

    /**
     * Gets query for [[Game]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getGame()
    {
        return $this->hasOne(Game::class, ['id' => 'game_id']);
    }

    /**
     * Gets query for [[User]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }

}
