<?php

use app\models\Application;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/** @var yii\web\View $this */
/** @var app\models\ApplicationSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Список заявок';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="application-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'id',
            'surname',
            'name',
            'patronymic',
            //'category_id',
            'game_id',
            'user_id',
            'date',
            'time',
            'adres',
            'price',
            'email:email',
            'phone_number',
            'status_player',
            'payment_method',
            'status',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, Application $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'id' => $model->id]);
                }
            ],
        ],
    ]); ?>


</div>
<style>
    .application-index {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        min-height: 100vh;
        padding: 30px 20px;
    }

    .application-index h1 {
        color: #2c3e50;
        font-weight: 700;
        text-align: center;
        margin-bottom: 30px;
        padding: 20px;
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        border-left: 5px solid #3498db;
        border-right: 5px solid #3498db;
    }

    /* Стили для таблицы GridView */
    .table {
        background: white;
        border-radius: 15px !important;
        overflow: hidden !important;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
        border: 2px solid #e0e0e0;
    }

    .table thead th {
        background: linear-gradient(135deg, #3498db, #2980b9) !important;
        color: white !important;
        font-weight: 600;
        padding: 18px 15px !important;
        border: none !important;
        vertical-align: middle;
        text-align: center;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        font-size: 14px;
        border-bottom: 3px solid #2980b9;
    }

    .table tbody td {
        padding: 15px !important;
        vertical-align: middle;
        border-top: 1px solid #f0f0f0 !important;
        color: #34495e;
        font-size: 14px;
        transition: all 0.2s;
    }

    .table tbody tr:hover {
        background-color: #f8fafc !important;
        transform: translateY(-2px);
        box-shadow: 0 3px 10px rgba(0,0,0,0.1);
    }

    .table tbody tr:nth-child(even) {
        background-color: #f8f9fa;
    }

    /* Кнопки действий */
    .action-column a {
        padding: 8px 12px;
        border-radius: 8px;
        margin: 2px;
        transition: all 0.3s;
        display: inline-block;
        text-decoration: none !important;
    }

    .action-column a:hover {
        transform: scale(1.1);
    }

    .action-column a:first-child { /* Просмотр */
        background: #e3f2fd;
        color: #1976d2;
        border: 1px solid #bbdefb;
    }

    .action-column a:first-child:hover {
        background: #bbdefb;
    }

    .action-column a:nth-child(2) { /* Изменить */
        background: #fff3e0;
        color: #f57c00;
        border: 1px solid #ffe0b2;
    }

    .action-column a:nth-child(2):hover {
        background: #ffe0b2;
    }

    .action-column a:nth-child(3) { /* Удалить */
        background: #ffebee;
        color: #d32f2f;
        border: 1px solid #ffcdd2;
    }

    .action-column a:nth-child(3):hover {
        background: #ffcdd2;
    }

    /* Серийный номер */
    .serial-column {
        text-align: center;
        font-weight: 600;
        color: #3498db;
        background: #f8f9fa;
    }

    /* Статусы */
    .status-column {
        text-align: center;
        font-weight: 600;
    }

    .status-new {
        background: #e3f2fd;
        color: #1976d2;
        padding: 5px 10px;
        border-radius: 20px;
        display: inline-block;
        font-size: 12px;
    }

    .status-confirmed {
        background: #e8f5e9;
        color: #2e7d32;
        padding: 5px 10px;
        border-radius: 20px;
        display: inline-block;
        font-size: 12px;
    }

    .status-cancelled {
        background: #ffebee;
        color: #d32f2f;
        padding: 5px 10px;
        border-radius: 20px;
        display: inline-block;
        font-size: 12px;
    }

    /* Способ оплаты */
    .payment-method {
        text-align: center;
    }

    .payment-0 { /* Банковской картой */
        background: #f3e5f5;
        color: #7b1fa2;
        padding: 5px 10px;
        border-radius: 20px;
        display: inline-block;
        font-size: 12px;
    }

    .payment-1 { /* Наличными */
        background: #fff3e0;
        color: #f57c00;
        padding: 5px 10px;
        border-radius: 20px;
        display: inline-block;
        font-size: 12px;
    }

    .payment-2 { /* Переводом */
        background: #e0f2f1;
        color: #00796b;
        padding: 5px 10px;
        border-radius: 20px;
        display: inline-block;
        font-size: 12px;
    }

    /* Уровень игрока */
    .player-level {
        text-align: center;
    }

    .level-novice {
        background: #e3f2fd;
        color: #1976d2;
        padding: 5px 10px;
        border-radius: 20px;
        display: inline-block;
        font-size: 12px;
    }

    .level-amateur {
        background: #fff3e0;
        color: #f57c00;
        padding: 5px 10px;
        border-radius: 20px;
        display: inline-block;
        font-size: 12px;
    }

    .level-pro {
        background: #e8f5e9;
        color: #2e7d32;
        padding: 5px 10px;
        border-radius: 20px;
        display: inline-block;
        font-size: 12px;
    }

    /* Фильтры */
    .filters {
        background: white;
        padding: 20px;
        border-radius: 15px;
        margin-bottom: 20px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }

    /* Пагинация */
    .pagination {
        display: flex;
        justify-content: center;
        margin-top: 30px;
        gap: 5px;
    }

    .pagination li {
        list-style: none;
    }

    .pagination li a {
        display: block;
        padding: 10px 15px;
        background: white;
        border: 2px solid #dfe6e9;
        border-radius: 10px;
        color: #2c3e50;
        text-decoration: none;
        transition: all 0.3s;
        font-weight: 600;
    }

    .pagination li.active a {
        background: linear-gradient(135deg, #3498db, #2980b9);
        color: white;
        border-color: #2980b9;
    }

    .pagination li a:hover {
        background: #e3f2fd;
        border-color: #3498db;
        transform: translateY(-2px);
    }

    /* Контейнер таблицы */
    .table-responsive {
        border-radius: 15px;
        overflow: hidden;
    }

    /* Адаптивность */
    @media (max-width: 768px) {
        .application-index {
            padding: 15px;
        }

        .application-index h1 {
            font-size: 24px;
            padding: 15px;
        }

        .table thead th,
        .table tbody td {
            padding: 10px 8px !important;
            font-size: 12px;
        }

        .action-column a {
            padding: 5px 8px;
            font-size: 12px;
        }

        .table-responsive {
            overflow-x: auto;
        }
    }

    /* Иконки в заголовках */
    .table thead th:first-child::before {
        content: '📋 ';
    }

    .table thead th:nth-child(2)::before {
        content: '👤 ';
    }

    .table thead th:nth-child(3)::before {
        content: '👤 ';
    }

    .table thead th:nth-child(4)::before {
        content: '👤 ';
    }

    .table thead th:nth-child(5)::before {
        content: '🎮 ';
    }

    .table thead th:nth-child(6)::before {
        content: '👤 ';
    }

    .table thead th:nth-child(7)::before {
        content: '📅 ';
    }

    .table thead th:nth-child(8)::before {
        content: '🕐 ';
    }

    .table thead th:nth-child(9)::before {
        content: '📍 ';
    }

    .table thead th:nth-child(10)::before {
        content: '💰 ';
    }

    .table thead th:nth-child(11)::before {
        content: '📧 ';
    }

    .table thead th:nth-child(12)::before {
        content: '📱 ';
    }

    .table thead th:nth-child(13)::before {
        content: '🏆 ';
    }

    .table thead th:nth-child(14)::before {
        content: '💳 ';
    }

    .table thead th:nth-child(15)::before {
        content: '📊 ';
    }

    .table thead th:nth-child(16)::before {
        content: '⚙️ ';
    }

    /* Анимация появления строк */
    @keyframes fadeInRow {
        from {
            opacity: 0;
            transform: translateX(-20px);
        }
        to {
            opacity: 1;
            transform: translateX(0);
        }
    }

    .table tbody tr {
        animation: fadeInRow 0.3s ease forwards;
    }

    .table tbody tr:nth-child(1) { animation-delay: 0.1s; }
    .table tbody tr:nth-child(2) { animation-delay: 0.2s; }
    .table tbody tr:nth-child(3) { animation-delay: 0.3s; }
    .table tbody tr:nth-child(4) { animation-delay: 0.4s; }
    .table tbody tr:nth-child(5) { animation-delay: 0.5s; }
    /* и так далее... */

    /* Полоса загрузки */
    .table::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 3px;
        background: linear-gradient(90deg, transparent, #3498db, transparent);
        animation: loading 1.5s infinite;
    }

    @keyframes loading {
        0% { left: -100%; }
        100% { left: 100%; }
    }

    /* Пустое состояние */
    .empty-text {
        text-align: center;
        padding: 40px;
        color: #7f8c8d;
        font-style: italic;
    }

    .empty-text::before {
        content: '🎲';
        font-size: 40px;
        display: block;
        margin-bottom: 15px;
        opacity: 0.5;
    }
</style>
