<div class="player-default-index">
    <div class="d-flex justify-content-center">
        <h2>Личный кабинет</h2>
    </div>
    <?= \yii\widgets\DetailView::widget([
        'model' => $user,
        'attributes' => [
            [
                'attribute' => 'surname',
                'label' => '<i class="fas fa-user-tag"></i> Фамилия',
                'format' => 'raw',
                'value' => function($model) {
                    return $model->surname ?: '<span class="text-muted">Не указано</span>';
                },
            ],
            [
                'attribute' => 'name',
                'label' => '<i class="fas fa-user"></i> Имя',
                'format' => 'raw',
                'value' => function($model) {
                    return $model->name ?: '<span class="text-muted">Не указано</span>';
                },
            ],
            [
                'attribute' => 'patronymic',
                'label' => '<i class="fas fa-user-friends"></i> Отчество',
                'format' => 'raw',
                'value' => function($model) {
                    return $model->patronymic ?: '<span class="text-muted">Не указано</span>';
                },
            ],
            [
                'attribute' => 'phone_number',
                'label' => '<i class="fas fa-phone"></i> Телефон',
                'format' => 'raw',
                'value' => function($model) {
                    return $model->phone_number
                        ? \yii\helpers\Html::a($model->phone_number, "tel:{$model->phone_number}")
                        : '<span class="text-muted">Не указан</span>';
                },
            ],
        ],
        'options' => [
            'class' => 'table table-hover table-bordered',
            'style' => 'border-radius: 10px; overflow: hidden;'
        ],
        'template' => '<tr><th style="width: 200px; background: #f8f9fa;">{label}</th><td>{value}</td></tr>',
    ]) ?>

    <div class="applications-container">
        <div class="page-header">
            <div class="d-flex justify-content-center">
                <h4>Мои заявки</h4>
            </div>
            <p>Здесь отображаются все ваши заявки на настольные игры</p>
        </div>

        <?php use yii\helpers\Url;

        if (empty($applications)): ?>
            <div class="no-applications">
                <p>У вас пока нет заявок на место</p>
                <p>Отправьте первую заявку!</p>
            </div>
        <?php else: ?>
            <?php foreach ($applications as $application): ?>
                <div class="application-card">
                    <p>Фамилия: <?= htmlspecialchars($application->surname); ?></p>
                    <p>Имя: <?= htmlspecialchars($application->name); ?></p>
                    <p>Отчество: <?= $application->patronymic ?? '❓ Не указано' ?></p>
                    <p>Номер телефона:<?= htmlspecialchars($application->phone_number); ?></p>
                    <p>Email: <?= htmlspecialchars($application->email); ?></p>
                    <p>Игра: <?= htmlspecialchars($application->game->name); ?></p>
                    <p>Адрес: <?= htmlspecialchars($application->adres); ?></p>
                    <p>Дата: <?= htmlspecialchars($application->date); ?></p>
                    <p>Время: <?= htmlspecialchars($application->time); ?></p>
                    <p>Уровень игрока: <?= htmlspecialchars($application->status_player); ?></p>
                    <p>Цена билета: <?= htmlspecialchars($application->price); ?> руб</p>
                    <p>Способ оплаты: <?= [0 => '💳 Банковской картой', 1 => '💵 Наличными', 2 => 'Переводом'][$application->payment_method] ?? '❓ Неизвестно' ?></p>
                    <p>Статус заявки: <?= htmlspecialchars($application->status); ?></p>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>

        <div class="btn-container">
            <a href="<?= Url::toRoute(['/site/application']); ?>" class="new-application-btn">
                Отправить новую заявку
            </a>
        </div>
</div>
    <style>
        /* Основные стили */
        .player-default-index {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
            background: linear-gradient(135deg, #f5f7fa 0%, #e4edf5 100%);
            min-height: 100vh;
        }

        /* Заголовок */
        .player-default-index h2 {
            color: #2c3e50;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 1.5px;
            margin-bottom: 30px;
            padding: 15px 30px;
            background: #fff;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
            border-left: 5px solid #3498db;
            border-right: 5px solid #3498db;
        }

        /* Стили для DetailView */
        .player-default-index .table {
            background: white;
            border-radius: 15px !important;
            overflow: hidden !important;
            box-shadow: 0 10px 30px rgba(52, 152, 219, 0.15);
            margin-bottom: 40px;
            border: 2px solid #e0e0e0;
        }

        .player-default-index .table th {
            background: linear-gradient(135deg, #3498db, #2980b9) !important;
            color: white !important;
            font-weight: 600;
            padding: 18px 20px !important;
            border: none !important;
            vertical-align: middle;
        }

        .player-default-index .table td {
            padding: 18px 20px !important;
            vertical-align: middle;
            border-top: 1px solid #f0f0f0 !important;
            color: #34495e;
            font-size: 16px;
        }

        .player-default-index .table tr:hover {
            background-color: #f8fafc !important;
            transition: background-color 0.3s ease;
        }

        /* Заголовок блока заявок */
        .page-header {
            text-align: center;
            margin: 40px 0 30px;
            padding: 25px;
            background: white;
            border-radius: 20px;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
            position: relative;
            overflow: hidden;
        }

        .page-header::before {
            content: '🎲 ♟️ 🃏';
            font-size: 40px;
            opacity: 0.1;
            position: absolute;
            top: 10px;
            right: 20px;
        }

        .page-header h4 {
            color: #2c3e50;
            font-weight: 700;
            font-size: 24px;
            margin-bottom: 10px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .page-header p {
            color: #7f8c8d;
            font-size: 16px;
            max-width: 600px;
            margin: 0 auto;
        }

        /* Карточка заявки */
        .applications-container {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
            gap: 25px;
            margin-bottom: 40px;
        }

        .application-card {
            background: white;
            border-radius: 20px;
            padding: 25px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            border: 2px solid transparent;
            background-clip: padding-box;
            position: relative;
            overflow: hidden;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            background: linear-gradient(145deg, #ffffff, #f9f9f9);
        }

        .application-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 5px;
            background: linear-gradient(90deg, #3498db, #9b59b6, #e74c3c);
        }

        .application-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
            border-color: #3498db;
        }

        .application-card p {
            margin: 12px 0;
            color: #2c3e50;
            font-size: 15px;
            line-height: 1.5;
            padding-left: 10px;
            border-left: 3px solid #3498db;
        }

        .application-card p:first-child {
            font-size: 18px;
            font-weight: 600;
            color: #2980b9;
            border-left: 5px solid #e74c3c;
        }

        /* Статус заявки - особый стиль */
        .application-card p:last-child {
            background: linear-gradient(135deg, #f8f9fa, #e9ecef);
            padding: 15px;
            border-radius: 10px;
            margin-top: 20px;
            border-left: 5px solid #2ecc71;
            font-weight: 600;
            color: #27ae60;
        }

        /* Блок без заявок */
        .no-applications {
            grid-column: 1 / -1;
            text-align: center;
            padding: 60px 40px;
            background: white;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.05);
            border: 3px dashed #bdc3c7;
            background-image: radial-gradient(#f1f1f1 2px, transparent 2px);
            background-size: 30px 30px;
        }

        .no-applications p:first-child {
            font-size: 24px;
            color: #2c3e50;
            font-weight: 600;
            margin-bottom: 15px;
        }

        .no-applications p:last-child {
            font-size: 18px;
            color: #7f8c8d;
            font-style: italic;
        }

        /* Кнопка новой заявки */
        .btn-container {
            text-align: center;
            margin: 50px 0 30px;
            padding: 20px;
        }

        .new-application-btn {
            display: inline-block;
            padding: 18px 45px;
            background: linear-gradient(135deg, #3498db, #2980b9);
            color: white;
            text-decoration: none;
            border-radius: 50px;
            font-weight: 700;
            font-size: 18px;
            text-transform: uppercase;
            letter-spacing: 1px;
            transition: all 0.3s ease;
            box-shadow: 0 10px 25px rgba(52, 152, 219, 0.4);
            border: none;
            cursor: pointer;
            position: relative;
            overflow: hidden;
        }

        .new-application-btn::before {
            content: '🎮';
            margin-right: 12px;
            font-size: 20px;
        }

        .new-application-btn::after {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
            transition: left 0.6s;
        }

        .new-application-btn:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 35px rgba(52, 152, 219, 0.6);
            background: linear-gradient(135deg, #2980b9, #21618c);
            color: white;
            text-decoration: none;
        }

        .new-application-btn:hover::after {
            left: 100%;
        }

        /* Адаптивность */
        @media (max-width: 768px) {
            .player-default-index {
                padding: 15px;
            }

            .applications-container {
                grid-template-columns: 1fr;
            }

            .player-default-index h2 {
                font-size: 20px;
                padding: 12px 20px;
            }

            .application-card {
                padding: 20px;
            }

            .new-application-btn {
                padding: 15px 30px;
                font-size: 16px;
                width: 100%;
            }
        }

        /* Анимации */
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .application-card {
            animation: fadeIn 0.6s ease forwards;
        }

        /* Декоративные элементы игровой тематики */
        .applications-container::before {
            content: '♟️ 🎲 🃏 🎯';
            font-size: 24px;
            display: block;
            text-align: center;
            margin: 20px 0;
            opacity: 0.3;
            letter-spacing: 20px;
        }

        /* Стили для иконок в таблице */
        .player-default-index .table th i {
            margin-right: 10px;
            font-size: 18px;
        }

        /* Стили для цены билета */
        .application-card p:nth-last-child(3) {
            background: linear-gradient(135deg, #fff9e6, #ffebcc);
            border-left: 5px solid #f39c12;
            color: #e67e22;
            font-weight: 600;
        }

        /* Стили для способа оплаты */
        .application-card p:nth-last-child(2) {
            background: linear-gradient(135deg, #e8f6f3, #d1f2eb);
            border-left: 5px solid #1abc9c;
            color: #16a085;
        }
    </style>