<?php

/** @var yii\web\View $this */

use yii\bootstrap5\Html;
use yii\helpers\Url;

$this->title = 'My Yii Application';
?>
<div class="site-index">

    <div class="jumbotron text-center bg-transparent mt-5 mb-5">
        <h1 class="display-4">Настольные игры для любой компании!</h1>

        <p class="lead">Играйте с нами!</p>

        <a class="btn btn-primary btn-lg" href="<?= Url::toRoute(['site/application']); ?>">Записаться на игру</a>
    </div>
</div>
<style>
    .site-index {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        min-height: 100vh;
        padding: 20px 0;
    }

    .jumbotron {
        padding: 60px 30px !important;
        margin-bottom: 40px !important;
        border-radius: 30px !important;
        background: linear-gradient(135deg, #ffffff, #f8f9fa) !important;
        box-shadow: 0 15px 40px rgba(0, 0, 0, 0.1) !important;
        border: 3px solid #e3f2fd;
        position: relative;
        overflow: hidden;
    }

    .jumbotron::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 8px;
        background: linear-gradient(90deg, #3498db, #9b59b6, #e74c3c);
        z-index: 1;
    }

    .display-4 {
        color: #2c3e50 !important;
        font-weight: 800 !important;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin-bottom: 25px !important;
        position: relative;
        padding-bottom: 20px;
    }

    .display-4::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%);
        width: 200px;
        height: 4px;
        background: linear-gradient(90deg, #3498db, #2980b9);
        border-radius: 2px;
    }

    .lead {
        color: #7f8c8d !important;
        font-size: 22px !important;
        margin-bottom: 35px !important;
        font-weight: 500;
    }

    .btn-lg {
        padding: 18px 50px !important;
        font-size: 20px !important;
        font-weight: 700 !important;
        text-transform: uppercase;
        letter-spacing: 1.5px;
        border-radius: 30px !important;
        background: linear-gradient(135deg, #3498db, #2980b9) !important;
        border: none !important;
        box-shadow: 0 10px 30px rgba(52, 152, 219, 0.4) !important;
        transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1) !important;
        position: relative;
        overflow: hidden;
    }

    .btn-lg:hover {
        transform: translateY(-5px) scale(1.05) !important;
        box-shadow: 0 20px 40px rgba(52, 152, 219, 0.6) !important;
        background: linear-gradient(135deg, #2980b9, #21618c) !important;
    }

    .btn-lg::before {
        content: '🎮 ';
        margin-right: 10px;
    }

    .btn-lg::after {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
        transition: left 0.6s;
    }

    .btn-lg:hover::after {
        left: 100%;
    }

    /* Карусель */
    #carouselExampleInterval {
        max-width: 1200px;
        margin: 0 auto;
        border-radius: 25px;
        overflow: hidden;
        box-shadow: 0 20px 50px rgba(0, 0, 0, 0.2);
        border: 5px solid white;
        position: relative;
    }

    .carousel-inner {
        height: 500px;
        overflow: hidden;
    }

    .carousel-item {
        height: 100%;
        width: 100%;
    }

    .carousel-item img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        object-position: center;
        transition: transform 0.8s ease;
    }

    .carousel-item.active img {
        transform: scale(1.05);
    }

    /* Управление каруселью */
    .carousel-control-prev,
    .carousel-control-next {
        width: 60px;
        height: 60px;
        background: rgba(255, 255, 255, 0.2);
        border-radius: 50%;
        top: 50%;
        transform: translateY(-50%);
        margin: 0 20px;
        backdrop-filter: blur(10px);
        border: 2px solid rgba(255, 255, 255, 0.3);
        transition: all 0.3s;
    }

    .carousel-control-prev:hover,
    .carousel-control-next:hover {
        background: rgba(52, 152, 219, 0.8);
        transform: translateY(-50%) scale(1.1);
    }

    .carousel-control-prev {
        left: 20px;
    }

    .carousel-control-next {
        right: 20px;
    }

    .carousel-control-prev-icon,
    .carousel-control-next-icon {
        width: 25px;
        height: 25px;
    }

    /* Индикаторы карусели */
    .carousel-indicators {
        bottom: 20px;
    }

    .carousel-indicators [data-target] {
        width: 15px;
        height: 15px;
        border-radius: 50%;
        border: 2px solid white;
        background: transparent;
        margin: 0 8px;
        transition: all 0.3s;
    }

    .carousel-indicators .active {
        background: #3498db;
        border-color: #3498db;
        transform: scale(1.2);
    }

    /* Анимации */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .jumbotron {
        animation: fadeInUp 0.8s ease;
    }

    #carouselExampleInterval {
        animation: fadeInUp 1s ease;
    }

    /* Декоративные элементы */
    .site-index::before {
        content: '♟️ 🎲 🎮 🃏 🎯';
        position: fixed;
        top: 50%;
        right: 20px;
        transform: translateY(-50%);
        opacity: 0.03;
        font-size: 100px;
        white-space: nowrap;
        z-index: -1;
        pointer-events: none;
    }

    /* Информационные карточки (дополнительно) */
    .info-cards {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 30px;
        margin: 50px auto;
        max-width: 1200px;
        padding: 0 20px;
    }

    .info-card {
        background: white;
        border-radius: 20px;
        padding: 30px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        text-align: center;
        border-top: 5px solid #3498db;
        transition: all 0.3s;
    }

    .info-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
    }

    .info-card h3 {
        color: #2c3e50;
        margin-bottom: 15px;
        font-weight: 700;
    }

    .info-card p {
        color: #7f8c8d;
        margin: 0;
    }

    /* Адаптивность */
    @media (max-width: 1200px) {
        .carousel-inner {
            height: 450px;
        }
    }

    @media (max-width: 992px) {
        .carousel-inner {
            height: 400px;
        }

        .display-4 {
            font-size: 2.5rem !important;
        }

        .lead {
            font-size: 20px !important;
        }
    }

    @media (max-width: 768px) {
        .site-index {
            padding: 10px;
        }

        .jumbotron {
            padding: 40px 20px !important;
            margin-bottom: 30px !important;
        }

        .carousel-inner {
            height: 350px;
        }

        .display-4 {
            font-size: 2rem !important;
            padding-bottom: 15px;
        }

        .btn-lg {
            padding: 15px 40px !important;
            font-size: 18px !important;
        }

        .carousel-control-prev,
        .carousel-control-next {
            width: 50px;
            height: 50px;
            margin: 0 10px;
        }
    }

    @media (max-width: 576px) {
        .carousel-inner {
            height: 300px;
        }

        .display-4 {
            font-size: 1.8rem !important;
            letter-spacing: 1px;
        }

        .lead {
            font-size: 18px !important;
        }

        .btn-lg {
            padding: 12px 30px !important;
            font-size: 16px !important;
            width: 100%;
        }

        .info-cards {
            grid-template-columns: 1fr;
        }

        .carousel-control-prev,
        .carousel-control-next {
            display: none;
        }
    }

    /* Эффект затемнения карусели */
    .carousel-item::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(to bottom, rgba(0, 0, 0, 0.2), rgba(0, 0, 0, 0.1));
        z-index: 1;
    }

    /* Подпись для карусели (опционально) */
    .carousel-caption {
        background: rgba(0, 0, 0, 0.7);
        padding: 20px;
        border-radius: 15px;
        bottom: 60px;
        left: 50%;
        transform: translateX(-50%);
        width: 80%;
        max-width: 600px;
    }

    .carousel-caption h5 {
        color: white;
        font-size: 24px;
        font-weight: 700;
        margin-bottom: 10px;
    }

    .carousel-caption p {
        color: rgba(255, 255, 255, 0.9);
        margin: 0;
    }
</style>
<div class="info-cards">
    <div class="info-card">
        <h3>🎲 Большой выбор</h3>
        <p>Множество различных настольных игр на любой вкус</p>
    </div>

    <div class="info-card">
        <h3>👥 Любая компания</h3>
        <p>От 2 до 10 человек. Идеально для друзей и семьи</p>
    </div>

    <div class="info-card">
        <h3>🏆 Турниры</h3>
        <p>Регулярные соревнования и призы для победителей</p>
    </div>
</div>