<?php

/** @var yii\web\View $this */
/** @var yii\bootstrap5\ActiveForm $form */

/** @var app\models\LoginForm $model */

use yii\bootstrap5\ActiveForm;
use yii\bootstrap5\Html;
use yii\helpers\Url;
use yii\widgets\MaskedInput;

$this->title = 'Авторизация';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="site-login">
    <h1><?= Html::encode($this->title) ?></h1>

    <p>Заполните эти поля для входа:</p>

    <div class="row">
        <div class="col-lg-5">

            <?php $form = ActiveForm::begin([
                'id' => 'login-form',
                'fieldConfig' => [
                    'template' => "{label}\n{input}\n{error}",
                    'labelOptions' => ['class' => 'col-lg-1 col-form-label mr-lg-3'],
                    'inputOptions' => ['class' => 'col-lg-3 form-control'],
                    'errorOptions' => ['class' => 'col-lg-7 invalid-feedback'],
                ],
            ]); ?>

            <?= $form->field($model, 'phone_number')->widget(MaskedInput::class, [
                'mask' => '8(999)-999-99-99',
            ]) ?>

            <?= $form->field($model, 'password')->passwordInput() ?>

            <?= $form->field($model, 'rememberMe')->checkbox([
                'template' => "<div class=\"custom-control custom-checkbox\">{input} {label}</div>\n<div class=\"col-lg-8\">{error}</div>",
            ]) ?>

            <div class="form-group">
                <div>
                    <?= Html::submitButton('Войти', ['class' => 'btn btn-primary', 'name' => 'login-button']) ?>
                    <a href="<?= Url::toRoute(['site/signup']); ?>">Нет аккаунта? Регистрация</a>
                </div>
            </div>

            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>
    <style>
        .site-login {
            background: linear-gradient(135deg, #f5f7fa 0%, #e4edf5 100%);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding: 20px;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .site-login h1 {
            color: #2c3e50;
            font-weight: 800;
            text-transform: uppercase;
            letter-spacing: 2px;
            margin-bottom: 20px;
            text-align: center;
            padding: 20px 0;
            position: relative;
        }

        .site-login h1::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 150px;
            height: 4px;
            background: linear-gradient(90deg, #3498db, #9b59b6);
            border-radius: 2px;
        }

        .site-login p {
            text-align: center;
            color: #7f8c8d;
            font-size: 16px;
            margin-bottom: 30px;
            max-width: 400px;
        }

        .row {
            width: 100%;
            max-width: 500px;
            margin: 0 auto;
        }

        .col-lg-5 {
            width: 100%;
            background: white;
            border-radius: 25px;
            padding: 40px 35px;
            box-shadow: 0 20px 50px rgba(0, 0, 0, 0.15);
            border: 3px solid #e0e0e0;
            position: relative;
            overflow: hidden;
        }

        .col-lg-5::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 8px;
            background: linear-gradient(90deg, #3498db, #9b59b6, #e74c3c);
        }

        /* Иконка для заголовка */
        .site-login h1::before {
            content: '🔑 🎮';
            position: absolute;
            top: -10px;
            left: 50%;
            transform: translateX(-50%);
            opacity: 0.2;
            font-size: 30px;
        }

        /* Стили для формы */
        #login-form {
            margin-top: 20px;
        }

        .form-group {
            margin-bottom: 25px;
        }

        .form-group label {
            font-weight: 600;
            color: #2c3e50;
            margin-bottom: 8px;
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 15px;
        }

        /* Иконки для полей */
        .field-loginform-phone_number label::before {
            content: "📱";
            color: #3498db;
        }

        .field-loginform-password label::before {
            content: "🔒";
            color: #3498db;
        }

        /* Поля ввода */
        .form-control {
            border: 2px solid #dfe6e9;
            border-radius: 12px;
            padding: 14px 18px;
            font-size: 16px;
            transition: all 0.3s;
            background: #f8f9fa;
            width: 100%;
        }

        .form-control:focus {
            border-color: #3498db;
            box-shadow: 0 0 0 3px rgba(52, 152, 219, 0.25);
            background: white;
            transform: translateY(-2px);
        }

        /* Маскированный ввод для телефона */
        input[type="tel"] {
            font-family: monospace;
            letter-spacing: 1px;
        }

        /* Чекбокс "Запомнить меня" */
        .custom-control {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 20px;
        }

        .custom-checkbox .custom-control-input {
            width: 20px;
            height: 20px;
            border: 2px solid #dfe6e9;
            border-radius: 6px;
            cursor: pointer;
        }

        .custom-checkbox .custom-control-input:checked {
            background-color: #3498db;
            border-color: #3498db;
        }

        .custom-checkbox .custom-control-label {
            color: #2c3e50;
            font-weight: 500;
            cursor: pointer;
            user-select: none;
        }

        .custom-checkbox .custom-control-label::before {
            content: '💾 ';
            margin-right: 5px;
        }

        /* Кнопка входа */
        .form-group:last-child {
            text-align: center;
            margin-top: 30px;
        }

        .btn-primary {
            background: linear-gradient(135deg, #3498db, #2980b9);
            border: none;
            border-radius: 25px;
            padding: 15px 40px;
            font-size: 18px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 1px;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: 0 10px 30px rgba(52, 152, 219, 0.4);
            min-width: 200px;
            display: inline-block;
            margin-bottom: 20px;
        }

        .btn-primary:hover {
            transform: translateY(-5px) scale(1.05);
            box-shadow: 0 20px 40px rgba(52, 152, 219, 0.6);
            background: linear-gradient(135deg, #2980b9, #21618c);
            color: white;
            text-decoration: none;
        }

        .btn-primary:active {
            transform: translateY(-2px) scale(1.02);
        }

        /* Ссылка на регистрацию */
        .form-group a {
            display: inline-block;
            color: #3498db;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s;
            padding: 10px 20px;
            border-radius: 12px;
            background: #f8f9fa;
            border: 2px solid #dfe6e9;
            margin-top: 10px;
        }

        .form-group a:hover {
            background: #e3f2fd;
            border-color: #3498db;
            transform: translateY(-2px);
            color: #2980b9;
            text-decoration: none;
        }

        .form-group a::before {
            content: '👤 ';
            margin-right: 8px;
        }

        /* Анимации */
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes slideIn {
            from {
                opacity: 0;
                transform: translateX(-30px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }

        .col-lg-5 {
            animation: fadeIn 0.8s ease;
        }

        .site-login h1 {
            animation: slideIn 0.6s ease;
        }

        .site-login p {
            animation: slideIn 0.7s ease;
        }

        .form-group {
            animation: slideIn 0.8s ease forwards;
            opacity: 0;
        }

        .form-group:nth-child(1) { animation-delay: 0.2s; }
        .form-group:nth-child(2) { animation-delay: 0.3s; }
        .form-group:nth-child(3) { animation-delay: 0.4s; }
        .form-group:last-child { animation-delay: 0.5s; }

        /* Декоративные элементы */
        .site-login::before {
            content: '♟️ 🎲 🎮 🃏';
            position: fixed;
            top: 50%;
            right: 20px;
            transform: translateY(-50%);
            opacity: 0.03;
            font-size: 80px;
            white-space: nowrap;
            z-index: -1;
            pointer-events: none;
        }

        /* Валидация ошибок */
        .has-error .form-control {
            border-color: #e74c3c;
            background: #ffeaea;
        }

        .invalid-feedback {
            color: #e74c3c;
            font-size: 14px;
            margin-top: 8px;
            font-weight: 500;
            display: block;
        }

        /* Успешная валидация */
        .has-success .form-control {
            border-color: #2ecc71;
            background: #e8f5e9;
        }

        /* Адаптивность */
        @media (max-width: 768px) {
            .site-login {
                padding: 15px;
            }

            .col-lg-5 {
                padding: 30px 20px;
            }

            .site-login h1 {
                font-size: 24px;
                padding: 15px 0;
            }

            .btn-primary {
                padding: 12px 30px;
                font-size: 16px;
                min-width: 180px;
            }

            .form-control {
                padding: 12px 15px;
            }

            .site-login p {
                font-size: 15px;
                padding: 0 10px;
            }
        }

        @media (max-width: 480px) {
            .col-lg-5 {
                padding: 25px 15px;
            }

            .site-login h1 {
                font-size: 20px;
            }

            .btn-primary {
                width: 100%;
                min-width: auto;
            }

            .form-group a {
                padding: 8px 15px;
                font-size: 14px;
                display: block;
                text-align: center;
            }

            .site-login::before {
                display: none;
            }
        }

        /* Плейсхолдеры */
        ::placeholder {
            color: #95a5a6;
            opacity: 0.7;
        }

        .form-control:focus::placeholder {
            opacity: 0.5;
        }

        /* Пароль показать/скрыть (дополнительно) */
        .password-toggle {
            position: relative;
        }

        .password-toggle .toggle-icon {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: #7f8c8d;
            font-size: 18px;
            transition: color 0.3s;
        }

        .password-toggle .toggle-icon:hover {
            color: #3498db;
        }

        /* Информационное сообщение */
        .col-lg-5::after {
            content: '🎮 Добро пожаловать в мир настольных игр! 🎲';
            display: block;
            text-align: center;
            margin-top: 25px;
            color: #7f8c8d;
            font-style: italic;
            font-size: 14px;
            padding: 10px;
            background: #f8f9fa;
            border-radius: 10px;
            border: 1px dashed #bdc3c7;
        }

        /* Эффект пульсации для кнопки */
        @keyframes pulse {
            0% { box-shadow: 0 0 0 0 rgba(52, 152, 219, 0.7); }
            70% { box-shadow: 0 0 0 10px rgba(52, 152, 219, 0); }
            100% { box-shadow: 0 0 0 0 rgba(52, 152, 219, 0); }
        }

        .btn-primary {
            animation: pulse 2s infinite;
        }

        /* Загрузка формы */
        #login-form {
            position: relative;
        }

        #login-form.loading::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(255,255,255,0.8);
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 25px;
            z-index: 10;
        }

        #login-form.loading::before {
            content: '🎲';
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            font-size: 40px;
            z-index: 11;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: translate(-50%, -50%) rotate(0deg); }
            100% { transform: translate(-50%, -50%) rotate(360deg); }
        }
    </style>
