<?php

use yii\bootstrap5\ActiveForm;
use yii\bootstrap5\Html;
use yii\helpers\Url;
use yii\widgets\MaskedInput; ?>
<div class="reg">
    <div class="col-lg-5">
        <div class="zagolovok">
            <h2>Регистрация</h2>
        </div>
        <?php
        $form = ActiveForm::begin([
            'id' => 'login-form',
            'options' => ['class' => 'form-horizontal'],
        ]) ?>
        <?= $form->field($model, 'surname')->textInput() ?>
        <?= $form->field($model, 'name')->textInput() ?>
        <?= $form->field($model, 'patronymic')->textInput() ?>
        <?= $form->field($model, 'phone_number')->widget(MaskedInput::class, [
            'mask' => '8(999)-999-99-99',
        ]) ?>
        <?= $form->field($model, 'email')->textInput() ?>
        <?= $form->field($model, 'password')->passwordInput() ?>
        <?= $form->field($model, 'password_repeat')->passwordInput() ?>

        <div class="form-group">
            <div class="d-flex justify-content-center align-items-center">
                <?= Html::submitButton('Создать пользователя', ['class' => 'btn btn-primary']) ?>
                <a href="<?= Url::toRoute(['site/login']); ?>">Есть аккаунт? Авторизация</a>
            </div>
        </div>
        <?php ActiveForm::end() ?>
    </div>
</div>
<style>
    .reg {
        background: linear-gradient(135deg, #f5f7fa 0%, #e4edf5 100%);
        min-height: 100vh;
        display: flex;
        justify-content: center;
        align-items: center;
        padding: 20px;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .reg .col-lg-5 {
        width: 100%;
        max-width: 500px;
        background: white;
        border-radius: 25px;
        padding: 40px 35px;
        box-shadow: 0 20px 50px rgba(0, 0, 0, 0.15);
        border: 3px solid #e0e0e0;
        position: relative;
        overflow: hidden;
    }

    .reg .col-lg-5::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 8px;
        background: linear-gradient(90deg, #3498db, #9b59b6, #e74c3c, #f39c12);
    }

    .zagolovok {
        text-align: center;
        margin-bottom: 30px;
        position: relative;
    }

    .zagolovok h2 {
        color: #2c3e50;
        font-weight: 800;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin-bottom: 20px;
        padding-bottom: 15px;
        position: relative;
    }

    .zagolovok h2::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%);
        width: 100px;
        height: 4px;
        background: linear-gradient(90deg, #3498db, #2980b9);
        border-radius: 2px;
    }

    .zagolovok::before {
        content: '👤 🎮 ♟️';
        position: absolute;
        top: -15px;
        left: 50%;
        transform: translateX(-50%);
        opacity: 0.1;
        font-size: 40px;
    }

    /* Стили для формы */
    .form-horizontal .form-group {
        margin-bottom: 25px;
    }

    .form-horizontal .form-group label {
        font-weight: 600;
        color: #2c3e50;
        margin-bottom: 8px;
        display: flex;
        align-items: center;
        gap: 8px;
        font-size: 15px;
    }

    .form-horizontal .form-group label::before {
        font-family: "Font Awesome 5 Free";
        font-weight: 900;
        color: #3498db;
    }

    /* Иконки для полей */
    .field-users-surname label::before {
        content: "👤";
    }

    .field-users-name label::before {
        content: "📝";
    }

    .field-users-patronymic label::before {
        content: "👨‍👩‍👧‍👦";
    }

    .field-users-phone_number label::before {
        content: "📱";
    }

    .field-users-email label::before {
        content: "📧";
    }

    .field-users-password label::before {
        content: "🔒";
    }

    .field-users-password_repeat label::before {
        content: "🔐";
    }

    /* Поля ввода */
    .form-control {
        border: 2px solid #dfe6e9;
        border-radius: 12px;
        padding: 14px 18px;
        font-size: 16px;
        transition: all 0.3s;
        background: #f8f9fa;
        height: auto;
    }

    .form-control:focus {
        border-color: #3498db;
        box-shadow: 0 0 0 3px rgba(52, 152, 219, 0.25);
        background: white;
        transform: translateY(-2px);
    }

    /* Маскированный ввод для телефона */
    input[type="tel"] {
        font-family: monospace;
        letter-spacing: 1px;
    }

    /* Кнопка отправки */
    .form-group:last-child {
        margin-top: 35px;
        text-align: center;
    }

    .btn-primary {
        background: linear-gradient(135deg, #3498db, #2980b9);
        border: none;
        border-radius: 25px;
        padding: 15px 40px;
        font-size: 18px;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 1px;
        transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        box-shadow: 0 10px 30px rgba(52, 152, 219, 0.4);
        display: inline-block;
        min-width: 250px;
    }

    .btn-primary:hover {
        transform: translateY(-5px) scale(1.05);
        box-shadow: 0 20px 40px rgba(52, 152, 219, 0.6);
        background: linear-gradient(135deg, #2980b9, #21618c);
    }

    .btn-primary:active {
        transform: translateY(-2px) scale(1.02);
    }

    /* Ссылка на авторизацию */
    .form-group a {
        display: block;
        margin-top: 20px;
        color: #3498db;
        text-decoration: none;
        font-weight: 600;
        transition: all 0.3s;
        padding: 10px 20px;
        border-radius: 12px;
        background: #f8f9fa;
        border: 2px solid #dfe6e9;
    }

    .form-group a:hover {
        background: #e3f2fd;
        border-color: #3498db;
        transform: translateY(-2px);
        color: #2980b9;
        text-decoration: none;
    }

    .form-group a::before {
        content: '🔑 ';
        margin-right: 8px;
    }

    /* Анимации */
    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .reg .col-lg-5 {
        animation: fadeIn 0.6s ease;
    }

    .form-group {
        animation: fadeIn 0.6s ease forwards;
        opacity: 0;
    }

    .form-group:nth-child(1) { animation-delay: 0.1s; }
    .form-group:nth-child(2) { animation-delay: 0.2s; }
    .form-group:nth-child(3) { animation-delay: 0.3s; }
    .form-group:nth-child(4) { animation-delay: 0.4s; }
    .form-group:nth-child(5) { animation-delay: 0.5s; }
    .form-group:nth-child(6) { animation-delay: 0.6s; }
    .form-group:nth-child(7) { animation-delay: 0.7s; }
    .form-group:last-child { animation-delay: 0.8s; }

    /* Декоративные элементы */
    .reg::before {
        content: '♟️ 🎲 🎮 🃏';
        position: fixed;
        top: 50%;
        right: 20px;
        transform: translateY(-50%);
        opacity: 0.03;
        font-size: 80px;
        white-space: nowrap;
        z-index: -1;
        pointer-events: none;
    }

    /* Валидация ошибок */
    .has-error .form-control {
        border-color: #e74c3c;
        background: #ffeaea;
    }

    .help-block {
        color: #e74c3c;
        font-size: 14px;
        margin-top: 8px;
        font-weight: 500;
    }

    /* Успешная валидация */
    .has-success .form-control {
        border-color: #2ecc71;
        background: #e8f5e9;
    }

    /* Адаптивность */
    @media (max-width: 768px) {
        .reg {
            padding: 15px;
        }

        .reg .col-lg-5 {
            padding: 30px 20px;
        }

        .zagolovok h2 {
            font-size: 24px;
        }

        .btn-primary {
            padding: 12px 30px;
            font-size: 16px;
            min-width: 200px;
        }

        .form-control {
            padding: 12px 15px;
        }
    }

    @media (max-width: 480px) {
        .reg .col-lg-5 {
            padding: 25px 15px;
        }

        .zagolovok h2 {
            font-size: 20px;
        }

        .btn-primary {
            width: 100%;
            min-width: auto;
        }

        .form-group a {
            padding: 8px 15px;
            font-size: 14px;
        }
    }

    /* Плейсхолдеры */
    ::placeholder {
        color: #95a5a6;
        opacity: 0.7;
    }

    /* Фокус на полях */
    .form-control:focus::placeholder {
        opacity: 0.5;
    }

    /* Информационная подсказка для пароля */
    .field-users-password .help-block,
    .field-users-password_repeat .help-block {
        color: #7f8c8d;
        font-size: 13px;
        font-style: italic;
    }

    /* Украшение для формы */
    .form-horizontal::after {
        content: '🎮 Присоединяйтесь к нашему игровому сообществу! 🎲';
        display: block;
        text-align: center;
        margin-top: 30px;
        color: #7f8c8d;
        font-style: italic;
        font-size: 14px;
        padding: 10px;
        background: #f8f9fa;
        border-radius: 10px;
        border: 1px dashed #bdc3c7;
    }
</style>


